************************************************************************************************
* Name			: table 4 - impact of the intervention on maternal labor supply  
*
* Description	: This dofile performs regressions of two measures of labour supply on 
* 				  treatment status and some covariates
************************************************************************************************

********************************************************************************
* SETTINGS 
********************************************************************************
clear 				all 
set more 			off 
set graphics 		off 
version 			15          /*Use Stata 15*/ 
set seed			16072015   	/* This is the seed number that was used to create the bootstrapped samples for estimation of the model in the paper */ 

* Options for data to create 
global testerFE 	no 			/*Take out tester FE before standardizing measures*/ 
global invar 		no 			/*Incorporate intercepts in the measurement system for when we will allow for measurement system variance*/ 
global pure 		no 			/*Only pure control and pure stimulation groups*/ 

* Globals of directories, variable groups and others 
run "$dir_statacode\globals.do" 

* Dataset with standardized measures 
use "$dir_data\measures.dta", clear 

********************************************************************************
* CLEANING 
********************************************************************************
gen totwklyhrs_mo1_zeros = totwklyhrs_mo1 
replace totwklyhrs_mo1_zeros = 0 if mwork1==0 

gen age_mo1_sq = age_mo1^2 

tab nkids1, gen(nokids) 
gen nokids6plus = (nkids1>=6) if nkids1!=. 

********************************************************************************
* REGRESSIONS
********************************************************************************
probit mwork1 treat  $covs_labor , cl(cod_dane)
outreg2 using "$dir_output/Table4.xls", replace noaster dec(3) 

reg totwklyhrs_mo1_zeros  treat $covs_labor , cl(cod_dane)
outreg2 using "$dir_output/Table4.xls", append noaster dec(3) 

